/*
 * Decompiled with CFR 0.152.
 */
package jtbcore.db.sql;

import java.util.Date;
import jtbcore.util.DateUtil;
import jtbcore.util.NumberUtil;

public class SqlColumn {
    public String name = null;
    public String sqlDatatype = null;
    public boolean primaryKey = false;
    public boolean autoincrement = false;
    public DataType internalType;
    public int maxLen = -1;

    public String strValue(String v) {
        Date d;
        if (v == null || "null".equalsIgnoreCase(v)) {
            return null;
        }
        if (this.internalType == DataType.NUMERIC) {
            if ("false".equalsIgnoreCase(v)) {
                v = "0";
            }
            if ("true".equalsIgnoreCase(v)) {
                v = "1";
            }
        }
        if (this.internalType == DataType.BOOLEAN) {
            if (v.trim().length() == 0 || "false".equalsIgnoreCase(v) || "0".equals(v)) {
                return "0";
            }
            return "1";
        }
        if (this.internalType == DataType.REAL) {
            Double d2 = NumberUtil.tryParseDouble(v);
            if (d2 == null) {
                return null;
            }
            return d2.toString();
        }
        if ((this.internalType == DataType.TEXT || this.internalType == DataType.DATE) && v.matches("^\\/Date\\(\\d+\\)\\/$") && (d = DateUtil.string2date(v)) != null) {
            return DateUtil.dateForm2.format(d);
        }
        return v;
    }

    public static enum DataType {
        NUMERIC,
        REAL,
        TEXT,
        BOOLEAN,
        DATE;

    }
}

